class MH2_Weapon_Railgun extends Minigun2;

var float ShotAccuracy, LastShellSpawn;
var int Count;
var bool bOutOfAmmo, bFiredShot;
var() texture MuzzleFlashVariations[10];

var string WeaponOwner;

replication
{
	// Things the server should send to the client.
	reliable if( bNetOwner && Role==ROLE_Authority )
		WeaponOwner;
}

event float BotDesireability(Pawn Bot)
{

	return (0); 

}

auto state Pickup
{	
function Touch( actor Other )
	{
	if ( ValidTouch(Other) && Other.IsA('PlayerPawn') && WeaponOwner == PlayerPawn(Other).PlayerReplicationInfo.PlayerName) 
		{
		DeathMatchPlus(Level.Game).GiveWeapon(PlayerPawn(Other),"Monsterhunt2.MH2_Weapon_Railgun");
		PlayerPawn(Other).ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
		PlayerPawn(Other).PlaySound(PickupSound);
		SetRespawn();
		}
	}
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2.75*AimError, False, False);	
	EndTrace = StartTrace + Accuracy * (FRand() - 0.5 )* Y * 1000
		+ Accuracy * (FRand() - 0.5 ) * Z * 1000;
	AimDir = vector(AdjustedAim);
	EndTrace += (10000 * AimDir); 
	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);


	if ( VSize(HitLocation - StartTrace) > 250 )
		Spawn(class'MTracer',,, StartTrace + 96 * AimDir,rotator(EndTrace - StartTrace));

	ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local int rndDam;
	local UT_SpriteBallExplosion U;

	if (Other == Level)
		{ 
		U = spawn(class'UT_SpriteBallExplosion',,, HitLocation+HitNormal, Rotator(HitNormal));
		U.DrawScale = 0.15;
		U.LightRadius = 3;
		}
	else if ( (Other!=self) && (Other!=Owner) && (Other != None) ) 
	{
		U = spawn(class'UT_SpriteBallExplosion',,, HitLocation+HitNormal*9);
		U.DrawScale = 0.15;
		U.LightRadius = 3;
		if ( Other.IsA('Bot') && (FRand() < 0.2) )
			Pawn(Other).WarnTarget(Pawn(Owner), 500, X);
		rndDam = 20 + Rand(15);
		if ( FRand() < 0.2 )
			X *= 2.5;
		Other.TakeDamage(rndDam, Pawn(Owner), HitLocation, rndDam*500.0*X, MyDamageType);
	}
}

defaultproperties
{
PickupAmmoCount=200
PickupMessage="You got your Railgun back!"
ItemName="Railgun"
RespawnTime=0.00000
MultiSkins(0)=Texture'UnrealShare.Effect7.MyTex16'
MultiSkins(1)=Texture'UnrealShare.Effect7.MyTex16'
MultiSkins(2)=Texture'UnrealShare.Effect7.MyTex16'
MultiSkins(3)=Texture'UnrealShare.Effect7.MyTex16'
MultiSkins(4)=Texture'UnrealShare.Effect7.MyTex16'
}
